import cv2

from scantron import AnswerSheet
from imageloader import ImageLoader


def main():
    try:
        loader = ImageLoader("scan200p.pdf")
        for pagenum, img in enumerate(loader.images):
            sheet = AnswerSheet(img)
            print("\nid: ", sheet.id())
            answers = sheet.answers()[:21]
            for i, a in enumerate(answers):
                print(i, ":", a)
            cv2.imshow("page", img)
            key = cv2.waitKey(0)
            if key == 27:
                break
        loader = ImageLoader("key.jpg")
        sheet = AnswerSheet(loader.images[0])
        print("JPG:", sheet.answers())
    finally:
        cv2.destroyAllWindows()


if __name__ == "__main__":
    main()
